/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.recipes.fletching;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.itayfeder.nock_enough_arrows.recipes.fletching.FletchingRecipe;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class FletchingRecipeBuilder
implements RecipeBuilder {
    public final Ingredient fin;
    public final Ingredient shaft;
    public final Ingredient arrowhead;
    private final Item result;
    private final int count;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final FletchingRecipe.Serializer<?> serializer;

    private FletchingRecipeBuilder(Ingredient p_i231600_2_, Ingredient p_i231600_3_, Ingredient p_i231600_4_, ItemLike p_126180_, int p_126181_, FletchingRecipe.Serializer<?> p_126247_) {
        this.fin = p_i231600_2_;
        this.shaft = p_i231600_3_;
        this.arrowhead = p_i231600_4_;
        this.result = p_126180_.m_5456_();
        this.count = p_126181_;
        this.serializer = p_126247_;
    }

    public static FletchingRecipeBuilder build(ItemLike p_126250_, ItemLike p_126249_, ItemLike p_126251_, ItemLike p_126180_, int p_126181_) {
        return new FletchingRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126250_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126249_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126251_}), p_126180_, p_126181_, FletchingRecipe.SERIALIZER);
    }

    public FletchingRecipeBuilder unlockedBy(String p_126255_, CriterionTriggerInstance p_126256_) {
        this.advancement.m_138386_(p_126255_, p_126256_);
        return this;
    }

    public FletchingRecipeBuilder unlockedByItem(ItemLike item) {
        this.advancement.m_138386_("has_" + item.m_5456_().toString(), (CriterionTriggerInstance)FletchingRecipeBuilder.has(item));
        return this;
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike p_125978_) {
        return FletchingRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{p_125978_}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... p_126012_) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, p_126012_);
    }

    public FletchingRecipeBuilder group(@Nullable String p_176795_) {
        this.group = p_176795_;
        return this;
    }

    public void m_176498_(Consumer<FinishedRecipe> p_176499_) {
        super.m_176498_(p_176499_);
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> p_126205_, ResourceLocation p_126206_) {
        this.ensureValid(p_126206_);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126206_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126206_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126205_.accept(new Result(p_126206_, this.result, this.count, this.group == null ? "" : this.group, this.fin, this.shaft, this.arrowhead, this.advancement, new ResourceLocation(p_126206_.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + p_126206_.m_135815_())));
    }

    private void ensureValid(ResourceLocation p_126208_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126208_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        public final Ingredient fin;
        public final Ingredient shaft;
        public final Ingredient arrowhead;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation p_126222_, Item p_126223_, int p_126224_, String p_126225_, Ingredient p_i231600_2_, Ingredient p_i231600_3_, Ingredient p_i231600_4_, Advancement.Builder p_126227_, ResourceLocation p_126228_) {
            this.id = p_126222_;
            this.result = p_126223_;
            this.count = p_126224_;
            this.group = p_126225_;
            this.fin = p_i231600_2_;
            this.shaft = p_i231600_3_;
            this.arrowhead = p_i231600_4_;
            this.advancement = p_126227_;
            this.advancementId = p_126228_;
        }

        public void m_7917_(JsonObject p_126230_) {
            if (!this.group.isEmpty()) {
                p_126230_.addProperty("group", this.group);
            }
            p_126230_.add("fin", this.fin.m_43942_());
            p_126230_.add("shaft", this.shaft.m_43942_());
            p_126230_.add("arrowhead", this.arrowhead.m_43942_());
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            jsonobject.addProperty("count", (Number)this.count);
            p_126230_.add("result", (JsonElement)jsonobject);
        }

        public RecipeSerializer<?> m_6637_() {
            return FletchingRecipe.SERIALIZER;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

